<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';

requireLogin();
header('Content-Type: application/json');

$q = isset($_GET['q']) ? trim($_GET['q']) : '';

try {
    $sql = "
        SELECT 
            d.*, 
            c.name as customer_name, 
            c.email as customer_email, 
            c.phone as customer_phone, 
            u.username as created_by_name,
            q.quote_number as quotation_reference
        FROM deliveries d
        LEFT JOIN customers c ON d.customer_id = c.id
        JOIN users u ON d.created_by = u.id
        LEFT JOIN quotations q ON d.quotation_id = q.id
        WHERE 1=1
    ";
    $params = [];
    if ($q !== '') {
        $sql .= " AND (
            d.delivery_number LIKE ? OR
            c.name LIKE ? OR
            d.status LIKE ? OR
            q.quote_number LIKE ?
        )";
        $params[] = "%$q%";
        $params[] = "%$q%";
        $params[] = "%$q%";
        $params[] = "%$q%";
    }
    $sql .= " ORDER BY d.created_at DESC LIMIT 50";
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $deliveries = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode(['success' => true, 'deliveries' => $deliveries]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
} 